##  Copyright (C) 2014, 2015 Edwin L. (Ted) Woollett
##  http://www.csulb.edu/~woollett

##  sho1.R is a utility file associated with
##  Project 1 (Classical Scattering in a Central Potential)
##  associated with Ch. 1 (Numerical Differentiation, Quadrature, and Roots)
##   in the series Computational Physics with Maxima or R, 
##   See  project1.pdf for more info.

##  This program is free software; you can redistribute
##  it and/or modify it under the terms of the
##  GNU General Public License as published by
##  the Free Software Foundation; either version 2 
##  of the License, or (at your option) any later version. 

##  This program is distributed in the hope that it
##  will be useful, but WITHOUT ANY WARRANTY;
##  without even the implied warranty of MERCHANTABILITY
##  or FITNESS FOR A PARTICULAR PURPOSE. See the 
##  GNU General Public License for more details at
##   http://www.gnu.org/copyleft/gpl.html





## sho1.R
## simple harmonic oscillator with period = 1
## produces two side by side plots:
##  x vs t and vx vs t

 yini = c(x = 1, vx = 0)
 
 times = seq(0, 1, 0.001)
 
 sho = function(t, y, parms) {
     with( as.list(y), {
        dx = vx
        dvx = -4*pi^2*x
        list( c(dx, dvx) ) } ) }
    
    
 out = ode(times = times, y = yini, func = sho, parms = NULL)
 
 plot(out, lwd = 2)
 
 